import zipfile

jar_path = "1.16/1.16.jar"

try:
    with zipfile.ZipFile(jar_path, 'r') as zf:
        if 'META-INF/MANIFEST.MF' in zf.namelist():
            manifest = zf.read('META-INF/MANIFEST.MF').decode('utf-8')
            print("Manifest found:")
            print(manifest[:1000])  # Print first 1000 characters
            print("\n--- Looking for Main-Class ---")
            for line in manifest.splitlines():
                if 'Main-Class' in line:
                    print(f"Found: {line}")
        else:
            print("META-INF/MANIFEST.MF not found in jar file")
except Exception as e:
    print(f"Error: {e}")
